local t = Def.ActorFrame {};
-- Header bits
t[#t+1] = Def.ActorFrame {
	OnCommand=function(self)
		self:addx(-SCREEN_WIDTH):decelerate(0.6):addx(SCREEN_WIDTH)
	end;	
	OffCommand=function(self)
		self:decelerate(0.6):addx(-SCREEN_WIDTH)
	end;
	LoadActor(THEME:GetPathG("ScreenWithMenuElements", "sidepanel")) .. {
		InitCommand=function(self)
			self:horizalign(right):x(SCREEN_CENTER_X-319)
		end;
	};
	Def.Sprite {
		Texture="_play";
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X-302):y(SCREEN_TOP+31):horizalign(left):vertalign(middle)
		end;
		OffCommand=function(self) self:linear(0.1):diffusealpha(0) end;
	};	
	LoadFont("_exo 2 32px") .. {
		Name="HeaderText";
		Text=string.upper(Screen.String("HeaderText"));
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X-302+42):y(SCREEN_TOP+20):horizalign(left):vertalign(top):zoom(0.75):maxwidth(SCREEN_WIDTH*0.65)
			self:diffuse(color("#26BF99"))
		end;
		OffCommand=function(self) self:sleep(0.05):linear(0.1):diffusealpha(0) end;
		UpdateScreenHeaderMessageCommand=function(self,param)
			self:settext(param.Header);
		end;
	};
};

-- Arrows
t[#t+1] = LoadActor(THEME:GetPathG("ScreenSelect", "mode cursor")) .. {
	InitCommand=function(self)
		self:horizalign(center):x(SCREEN_CENTER_X+160):y(SCREEN_CENTER_Y+120):zoom(0.75)
	end;
	OnCommand=function(self)
		self:diffusealpha(0):linear(0.3):diffusealpha(1)
		self:bob():effectmagnitude(0,-6,0)
	end;
	OffCommand=function(self) self:stopeffect():linear(0.2):addy(20):diffusealpha(0) end
	};
	
t[#t+1] = LoadActor(THEME:GetPathG("ScreenSelect", "mode cursor")) .. {
	InitCommand=function(self)
		self:horizalign(center):x(SCREEN_CENTER_X+160):y(SCREEN_CENTER_Y-120):zoom(0.75):zoomy(-0.75)
	end;
	OnCommand=function(self)
		self:diffusealpha(0):linear(0.3):diffusealpha(1)
		self:bob():effectmagnitude(0,6,0)
	end;
	OffCommand=function(self) self:stopeffect():linear(0.2):addy(-20):diffusealpha(0) end
	};
	

if GAMESTATE:GetCurrentGame():GetName() == 'pump' then	
t[#t+1] = Def.Sprite {
		Texture="_pump";
		InitCommand=function(self)
			self:horizalign(center):x(SCREEN_CENTER_X+160):y(SCREEN_CENTER_Y):zoom(0.75)
		end;
		OnCommand=function(self)
			self:diffusealpha(0):linear(0.3):diffusealpha(1)
			self:wag():effectmagnitude(0,0,1.5):effectperiod(1.6)
		end;
		OffCommand=function(self) self:decelerate(0.2):diffusealpha(0) end;
	};
else
	t[#t+1] = Def.Sprite {
		Texture="_dance";
		InitCommand=function(self)
			self:horizalign(center):x(SCREEN_CENTER_X+160):y(SCREEN_CENTER_Y):zoom(0.75)
		end;
		OnCommand=function(self)
			self:diffusealpha(0):linear(0.3):diffusealpha(1)
			self:wag():effectmagnitude(0,0,1.5):effectperiod(1.6)
		end;
		OffCommand=function(self) self:decelerate(0.2):diffusealpha(0) end;
	};
end;

return t